import { incrementProjectViews } from '@/lib/storage';
import { NextResponse } from 'next/server';

export async function POST(request: Request) {
    try {
        const { projectId } = await request.json();

        if (!projectId) {
            return NextResponse.json({ error: 'Project ID is required' }, { status: 400 });
        }

        const views = await incrementProjectViews(projectId);

        return NextResponse.json({ views });
    } catch (error) {
        return NextResponse.json({ error: 'Failed to track view' }, { status: 500 });
    }
}
