import { Phone, MessageCircle, Truck, Package, ShieldCheck, Clock } from 'lucide-react';

export default function MovingTemplate({ data }: { data: Record<string, string> }) {
    return (
        <div className="font-sans text-gray-800 bg-white min-h-full" dir="rtl">
            {/* Hero Section */}
            <header className="relative py-20 bg-blue-900 text-white overflow-hidden">
                <div className="absolute inset-0 bg-[url('https://images.unsplash.com/photo-1600518464441-9154a4dea21b?auto=format&fit=crop&q=80')] bg-cover bg-center opacity-20" />
                <div className="container mx-auto px-4 relative z-10 flex flex-col md:flex-row items-center gap-12">
                    <div className="flex-1 text-center md:text-right">
                        <h1 className="text-4xl md:text-6xl font-bold mb-6 leading-tight">{data.heroTitle}</h1>
                        <p className="text-lg md:text-xl mb-8 text-blue-100">{data.heroDescription}</p>
                        <div className="flex flex-col sm:flex-row gap-4 justify-center md:justify-start">
                            <a href={`tel:${data.phone}`} className="bg-yellow-500 hover:bg-yellow-400 text-blue-900 px-8 py-4 rounded-lg font-bold flex items-center justify-center gap-2 transition-colors shadow-lg">
                                <Phone className="w-5 h-5" />
                                اتصل الآن
                            </a>
                            <a href={`https://wa.me/${data.whatsapp}`} className="bg-white text-blue-900 hover:bg-gray-100 px-8 py-4 rounded-lg font-bold flex items-center justify-center gap-2 transition-colors shadow-lg">
                                <MessageCircle className="w-5 h-5" />
                                واتساب
                            </a>
                        </div>
                    </div>
                    <div className="flex-1 hidden md:block">
                        <img src="https://images.unsplash.com/photo-1600518464441-9154a4dea21b?auto=format&fit=crop&q=80" alt="Moving" className="rounded-lg shadow-2xl border-4 border-white/20 transform rotate-2 hover:rotate-0 transition-transform duration-500" />
                    </div>
                </div>
            </header>

            {/* Features Section */}
            <section className="py-16 bg-gray-50">
                <div className="container mx-auto px-4">
                    <div className="grid md:grid-cols-3 gap-8">
                        <div className="bg-white p-8 rounded-xl shadow-sm hover:shadow-md transition-shadow text-center border-t-4 border-blue-600">
                            <div className="w-16 h-16 bg-blue-100 text-blue-600 rounded-full flex items-center justify-center mx-auto mb-6">
                                <Truck className="w-8 h-8" />
                            </div>
                            <h3 className="text-xl font-bold mb-2">{data.feature1}</h3>
                            <p className="text-gray-600">نمتلك أسطولاً من الشاحنات المجهزة لنقل عفشك بأمان تام.</p>
                        </div>
                        <div className="bg-white p-8 rounded-xl shadow-sm hover:shadow-md transition-shadow text-center border-t-4 border-blue-600">
                            <div className="w-16 h-16 bg-blue-100 text-blue-600 rounded-full flex items-center justify-center mx-auto mb-6">
                                <Package className="w-8 h-8" />
                            </div>
                            <h3 className="text-xl font-bold mb-2">{data.feature2}</h3>
                            <p className="text-gray-600">نستخدم أفضل مواد التغليف لحماية الأثاث من الخدوش والكسر.</p>
                        </div>
                        <div className="bg-white p-8 rounded-xl shadow-sm hover:shadow-md transition-shadow text-center border-t-4 border-blue-600">
                            <div className="w-16 h-16 bg-blue-100 text-blue-600 rounded-full flex items-center justify-center mx-auto mb-6">
                                <Clock className="w-8 h-8" />
                            </div>
                            <h3 className="text-xl font-bold mb-2">{data.feature3}</h3>
                            <p className="text-gray-600">نلتزم بالمواعيد ونضمن وصول عفشك في الوقت المحدد.</p>
                        </div>
                    </div>
                </div>
            </section>

            {/* Footer */}
            <footer className="bg-gray-900 text-white py-8 text-center">
                <div className="container mx-auto px-4">
                    <h2 className="text-2xl font-bold mb-4">{data.companyName}</h2>
                    <p className="text-gray-400 mb-6">خيارك الأول لنقل العفش بأمان وسرعة.</p>
                    <p>&copy; {new Date().getFullYear()} {data.companyName}. جميع الحقوق محفوظة.</p>
                </div>
            </footer>
        </div>
    );
}
