import { Phone, MessageCircle, DollarSign, Armchair, RefreshCw } from 'lucide-react';

export default function UsedFurnitureTemplate({ data }: { data: Record<string, string> }) {
    return (
        <div className="font-sans text-gray-800 bg-white min-h-full" dir="rtl">
            {/* Hero Section */}
            <header className="bg-amber-50 py-20 border-b border-amber-100">
                <div className="container mx-auto px-4 text-center">
                    <span className="inline-block bg-amber-200 text-amber-900 px-4 py-1 rounded-full text-sm font-bold mb-6">نشتري بأعلى الأسعار</span>
                    <h1 className="text-4xl md:text-6xl font-black mb-6 text-amber-950">{data.heroTitle}</h1>
                    <p className="text-xl text-amber-800 mb-10 max-w-3xl mx-auto">{data.heroDescription}</p>

                    <div className="bg-white p-6 rounded-2xl shadow-xl max-w-2xl mx-auto border border-amber-100">
                        <p className="text-lg font-bold mb-4 text-gray-700">تواصل معنا الآن لتقييم أثاثك فوراً</p>
                        <div className="flex flex-col sm:flex-row gap-4 justify-center">
                            <a href={`tel:${data.phone}`} className="flex-1 bg-amber-600 hover:bg-amber-700 text-white py-4 rounded-xl font-bold flex items-center justify-center gap-2 transition-colors text-lg">
                                <Phone className="w-5 h-5" />
                                اتصال: {data.phone}
                            </a>
                            <a href={`https://wa.me/${data.whatsapp}`} className="flex-1 bg-green-500 hover:bg-green-600 text-white py-4 rounded-xl font-bold flex items-center justify-center gap-2 transition-colors text-lg">
                                <MessageCircle className="w-5 h-5" />
                                واتساب
                            </a>
                        </div>
                    </div>
                </div>
            </header>

            {/* What We Buy */}
            <section className="py-16">
                <div className="container mx-auto px-4">
                    <h2 className="text-3xl font-bold text-center mb-12 text-gray-800">ماذا نشتري؟</h2>
                    <div className="grid grid-cols-2 md:grid-cols-4 gap-6">
                        {['غرف نوم', 'مطابخ', 'مكيفات', 'أجهزة كهربائية', 'مجالس', 'سجاد', 'أثاث مكتبي', 'خردة'].map((item, i) => (
                            <div key={i} className="bg-gray-50 p-6 rounded-xl text-center hover:bg-amber-50 transition-colors cursor-default border border-gray-100">
                                <Armchair className="w-8 h-8 mx-auto mb-3 text-amber-600" />
                                <span className="font-bold text-gray-700">{item}</span>
                            </div>
                        ))}
                    </div>
                </div>
            </section>

            {/* Service Areas */}
            <section className="py-12 bg-gray-900 text-white text-center">
                <div className="container mx-auto px-4">
                    <h3 className="text-xl font-bold mb-4">مناطق الخدمة</h3>
                    <p className="text-gray-400 text-lg">{data.area}</p>
                </div>
            </section>

            <footer className="py-6 text-center text-gray-500 text-sm">
                &copy; {new Date().getFullYear()} {data.companyName}
            </footer>
        </div>
    );
}
