import { TemplateConfig } from '@/types';

export const templates: TemplateConfig[] = [
    {
        id: 'landscaping',
        name: 'تنسيق حدائق',
        description: 'تصميم طبيعي وجذاب يعكس جمال الطبيعة، مثالي لشركات تنسيق الحدائق والمشاتل.',
        thumbnail: '/thumbnails/landscaping.jpg',
        fields: [
            { id: 'companyName', label: 'اسم الشركة', type: 'text', placeholder: 'مؤسسة الطبيعة الخضراء', required: true },
            { id: 'phone', label: 'رقم الهاتف', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'whatsapp', label: 'رقم الواتساب', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'heroTitle', label: 'العنوان الرئيسي', type: 'text', defaultValue: 'نحول حديقتك إلى واحة من الجمال' },
            { id: 'heroDescription', label: 'وصف مختصر', type: 'textarea', defaultValue: 'نقدم خدمات تنسيق الحدائق وتركيب العشب الصناعي والشلالات بأعلى جودة وأفضل الأسعار.' },
            { id: 'heroImage', label: 'صورة الخلفية الرئيسية', type: 'image' },
            { id: 'service1Title', label: 'عنوان الخدمة 1', type: 'text', defaultValue: 'تنسيق حدائق' },
            { id: 'service1Desc', label: 'وصف الخدمة 1', type: 'textarea', defaultValue: 'تصميم وتنفيذ حدائق منزلية وعامة بأحدث التصاميم.' },
            { id: 'service2Title', label: 'عنوان الخدمة 2', type: 'text', defaultValue: 'تركيب عشب صناعي' },
            { id: 'service2Desc', label: 'وصف الخدمة 2', type: 'textarea', defaultValue: 'عشب صناعي عالي الجودة مقاوم للشمس والمطر.' },
            { id: 'service3Title', label: 'عنوان الخدمة 3', type: 'text', defaultValue: 'شلالات ونوافير' },
            { id: 'service3Desc', label: 'وصف الخدمة 3', type: 'textarea', defaultValue: 'إضافة لمسة جمالية بصوت الماء العذب.' },
        ]
    },
    {
        id: 'moving',
        name: 'نقل عفش',
        description: 'تصميم يركز على السرعة والأمان، مثالي لشركات نقل الأثاث والخدمات اللوجستية.',
        thumbnail: '/thumbnails/moving.jpg',
        fields: [
            { id: 'companyName', label: 'اسم الشركة', type: 'text', placeholder: 'السريع لنقل العفش', required: true },
            { id: 'phone', label: 'رقم الهاتف', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'whatsapp', label: 'رقم الواتساب', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'heroTitle', label: 'العنوان الرئيسي', type: 'text', defaultValue: 'نقل عفش آمن وسريع' },
            { id: 'heroDescription', label: 'وصف مختصر', type: 'textarea', defaultValue: 'فريق متخصص في فك وتركيب وتغليف الأثاث مع الضمان.' },
            { id: 'feature1', label: 'ميزة 1', type: 'text', defaultValue: 'فك وتركيب شامل' },
            { id: 'feature2', label: 'ميزة 2', type: 'text', defaultValue: 'تغليف آمن' },
            { id: 'feature3', label: 'ميزة 3', type: 'text', defaultValue: 'سيارات مجهزة' },
        ]
    },
    {
        id: 'used-furniture',
        name: 'شراء اثاث مستعمل',
        description: 'تصميم بسيط ومباشر يسهل عملية البيع والشراء، مثالي لتجار الأثاث المستعمل.',
        thumbnail: '/thumbnails/used-furniture.jpg',
        fields: [
            { id: 'companyName', label: 'اسم الشركة', type: 'text', placeholder: 'أبو خالد للأثاث المستعمل', required: true },
            { id: 'phone', label: 'رقم الهاتف', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'whatsapp', label: 'رقم الواتساب', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'heroTitle', label: 'العنوان الرئيسي', type: 'text', defaultValue: 'نشتري جميع أنواع الأثاث المستعمل' },
            { id: 'heroDescription', label: 'وصف مختصر', type: 'textarea', defaultValue: 'نشتري غرف النوم، المطابخ، المكيفات، والأجهزة الكهربائية بأفضل الأسعار.' },
            { id: 'area', label: 'مناطق الخدمة', type: 'text', defaultValue: 'الرياض - جدة - الدمام' },
        ]
    },
    {
        id: 'contracting',
        name: 'مقاولات عامة',
        description: 'تصميم احترافي يعكس القوة والثقة، مثالي لشركات المقاولات والبناء.',
        thumbnail: '/thumbnails/contracting.jpg',
        fields: [
            { id: 'companyName', label: 'اسم الشركة', type: 'text', placeholder: 'مؤسسة البنيان للمقاولات', required: true },
            { id: 'phone', label: 'رقم الهاتف', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'whatsapp', label: 'رقم الواتساب', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'heroTitle', label: 'العنوان الرئيسي', type: 'text', defaultValue: 'نبني مستقبلك بإتقان' },
            { id: 'heroDescription', label: 'وصف مختصر', type: 'textarea', defaultValue: 'مقاولات عامة، تشطيبات، ترميم، وبناء ملاحق بأيدي خبراء.' },
            { id: 'project1', label: 'مشروع 1', type: 'image' },
            { id: 'project2', label: 'مشروع 2', type: 'image' },
        ]
    },
    {
        id: 'recruitment',
        name: 'استقدام عمالة',
        description: 'تصميم رسمي وموثوق، مثالي لمكاتب الاستقدام والخدمات العمالية.',
        thumbnail: '/thumbnails/recruitment.jpg',
        fields: [
            { id: 'companyName', label: 'اسم المكتب', type: 'text', placeholder: 'مكتب التيسير للاستقدام', required: true },
            { id: 'licenseNumber', label: 'رقم الترخيص', type: 'text', placeholder: 'ترخيص رقم: 123456' },
            { id: 'phone', label: 'رقم الهاتف', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'whatsapp', label: 'رقم الواتساب', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'heroTitle', label: 'العنوان الرئيسي', type: 'text', defaultValue: 'استقدام عمالة منزلية ومهنية' },
            { id: 'heroDescription', label: 'وصف مختصر', type: 'textarea', defaultValue: 'سرعة في الإنجاز، ومصداقية في التعامل. نوفر عمالة من مختلف الجنسيات.' },
            { id: 'countries', label: 'دول الاستقدام', type: 'text', defaultValue: 'الفلبين - إندونيسيا - كينيا - أوغندا' },
        ]
    },
    {
        id: 'decor',
        name: 'ديكور وتصميم داخلي',
        description: 'تصميم فني وأنيق يبرز جمال الأعمال، مثالي لمهندسي الديكور والمصممين.',
        thumbnail: '/thumbnails/decor.jpg',
        fields: [
            { id: 'companyName', label: 'اسم المصمم/الشركة', type: 'text', placeholder: 'لمسات فنية للديكور', required: true },
            { id: 'phone', label: 'رقم الهاتف', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'whatsapp', label: 'رقم الواتساب', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'heroTitle', label: 'العنوان الرئيسي', type: 'text', defaultValue: 'تصاميم داخلية تحكي قصتك' },
            { id: 'heroDescription', label: 'وصف مختصر', type: 'textarea', defaultValue: 'نحول مساحتك إلى تحفة فنية تجمع بين الأناقة والوظيفة.' },
            { id: 'portfolio1', label: 'صورة من أعمالنا 1', type: 'image' },
            { id: 'portfolio2', label: 'صورة من أعمالنا 2', type: 'image' },
            { id: 'portfolio3', label: 'صورة من أعمالنا 3', type: 'image' },
        ]
    },
    {
        id: 'pest-control',
        name: 'رش حشرات',
        description: 'تصميم نظيف يوحي بالتعقيم والحماية، مثالي لشركات مكافحة الحشرات.',
        thumbnail: '/thumbnails/pest-control.jpg',
        fields: [
            { id: 'companyName', label: 'اسم الشركة', type: 'text', placeholder: 'الدرع لمكافحة الحشرات', required: true },
            { id: 'phone', label: 'رقم الهاتف', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'whatsapp', label: 'رقم الواتساب', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'heroTitle', label: 'العنوان الرئيسي', type: 'text', defaultValue: 'تخلص من الحشرات نهائياً' },
            { id: 'heroDescription', label: 'وصف مختصر', type: 'textarea', defaultValue: 'مكافحة جميع أنواع الحشرات والقوارض بمبيدات آمنة وفعالة مع الضمان.' },
            { id: 'guarantee', label: 'مدة الضمان', type: 'text', defaultValue: 'ضمان 6 أشهر' },
        ]
    },
];
