# 🚀 تشغيل على VPS - الطريقة الأسهل!

VPS أسهل من cPanel! سكريبت واحد يعمل كل حاجة تلقائي!

---

## ⚡ الطريقة السريعة (3 دقائق!)

### 1️⃣ ارفع الملفات إلى VPS

**من جهازك:**

```bash
# ضغط الملفات
cd "d:\RAIED AI\site2"
tar -czf app.tar.gz .next prisma public src scripts ecosystem.config.js package*.json *.config.* setup-vps-auto.sh

# رفع إلى VPS
scp app.tar.gz root@YOUR_VPS_IP:/root/
```

### 2️⃣ تشغيل السكريبت التلقائي

**على VPS:**

```bash
# SSH إلى VPS
ssh root@YOUR_VPS_IP

# فك الضغط
cd /root
tar -xzf app.tar.gz

# تشغيل السكريبت (يعمل كل حاجة!)
chmod +x setup-vps-auto.sh
./setup-vps-auto.sh
```

**السكريبت هيعمل:**
- ✅ تثبيت Node.js
- ✅ تثبيت MySQL
- ✅ تثبيت Nginx
- ✅ تثبيت PM2
- ✅ إنشاء قاعدة البيانات
- ✅ إعداد التطبيق
- ✅ تشغيل التطبيق
- ✅ تكوين Nginx

**خلاص! 🎉**

### 3️⃣ تفعيل SSL (اختياري)

```bash
apt-get install -y certbot python3-certbot-nginx
certbot --nginx -d site.mdoante.com
```

---

## 📋 المتطلبات

- VPS مع Ubuntu 20.04+ أو Debian 11+
- صلاحيات root
- الذاكرة: 1GB+ (موصى به 2GB)
- المساحة: 10GB+

---

## 🎯 الأوامر الكاملة (نسخ ولصق)

### على جهازك (Windows):

```powershell
cd "d:\RAIED AI\site2"
tar -czf vps-deploy.tar.gz .next prisma public src scripts ecosystem.config.js package.json package-lock.json next.config.ts tsconfig.json postcss.config.mjs setup-vps-auto.sh
```

### رفع إلى VPS:

```powershell
# استبدل YOUR_VPS_IP بـ IP السيرفر
scp vps-deploy.tar.gz root@YOUR_VPS_IP:/root/
```

### على VPS:

```bash
# تسجيل الدخول
ssh root@YOUR_VPS_IP

# التثبيت
cd /root
tar -xzf vps-deploy.tar.gz
chmod +x setup-vps-auto.sh
./setup-vps-auto.sh
```

---

## 🔒 تفعيل HTTPS (Let's Encrypt)

```bash
# بعد ما التطبيق يشتغل:
apt-get install -y certbot python3-certbot-nginx
certbot --nginx -d site.mdoante.com

# التجديد التلقائي
certbot renew --dry-run
```

---

## 🛠️ أوامر الإدارة

### حالة التطبيق:
```bash
sudo -u appuser pm2 status
```

### السجلات:
```bash
sudo -u appuser pm2 logs
```

### إعادة التشغيل:
```bash
sudo -u appuser pm2 restart all
```

### حالة Nginx:
```bash
systemctl status nginx
systemctl reload nginx
```

### حالة MySQL:
```bash
systemctl status mysql
```

---

## 🔄 التحديثات المستقبلية

```bash
# 1. على جهازك - اضغط الملفات الجديدة
tar -czf update.tar.gz .next

# 2. ارفع إلى VPS
scp update.tar.gz root@YOUR_VPS_IP:/home/appuser/app/

# 3. على VPS - فك الضغط وإعادة التشغيل
cd /home/appuser/app
tar -xzf update.tar.gz
sudo -u appuser pm2 restart all
```

---

## 📊 مراقبة الأداء

### استخدام الموارد:
```bash
# CPU & Memory
htop

# مساحة القرص
df -h

# حالة PM2
sudo -u appuser pm2 monit
```

### السجلات:
```bash
# سجلات التطبيق
sudo -u appuser pm2 logs

# سجلات Nginx
tail -f /var/log/nginx/access.log
tail -f /var/log/nginx/error.log

# سجلات MySQL
tail -f /var/log/mysql/error.log
```

---

## 🔐 الأمان

### Firewall:
```bash
# تفعيل UFW
ufw allow 22/tcp
ufw allow 80/tcp
ufw allow 443/tcp
ufw enable
```

### تحديثات الأمان:
```bash
# تحديث تلقائي
apt-get install -y unattended-upgrades
dpkg-reconfigure -plow unattended-upgrades
```

### تأمين MySQL:
```bash
mysql_secure_installation
```

---

## 💾 النسخ الاحتياطي

### نسخة احتياطية يدوية:
```bash
# قاعدة البيانات
mysqldump -u landing_user -p landing_pages > backup-$(date +%Y%m%d).sql

# الملفات
tar -czf backup-$(date +%Y%m%d).tar.gz /home/appuser/app
```

### نسخة احتياطية تلقائية (Cron):
```bash
# أضف في crontab
crontab -e

# نسخة احتياطية يومية الساعة 2 صباحاً
0 2 * * * mysqldump -u landing_user -p'PASSWORD' landing_pages > /root/backups/db-$(date +\%Y\%m\%d).sql
0 2 * * * tar -czf /root/backups/app-$(date +\%Y\%m\%d).tar.gz /home/appuser/app
```

---

## 🆘 استكشاف الأخطاء

### التطبيق لا يعمل:
```bash
# تحقق من السجلات
sudo -u appuser pm2 logs

# تحقق من Port
netstat -tulpn | grep 3000

# أعد التشغيل
sudo -u appuser pm2 restart all
```

### Nginx 502 Bad Gateway:
```bash
# تحقق من أن التطبيق يعمل
sudo -u appuser pm2 status

# تحقق من تكوين Nginx
nginx -t

# أعد تحميل Nginx
systemctl reload nginx
```

### خطأ في قاعدة البيانات:
```bash
# تحقق من MySQL
systemctl status mysql

# اتصل بقاعدة البيانات
mysql -u landing_user -p landing_pages

# أعد تشغيل migrations
cd /home/appuser/app
sudo -u appuser npx prisma migrate deploy
```

---

## 📈 تحسين الأداء

### PM2 Cluster Mode:
```javascript
// في ecosystem.config.js
module.exports = {
  apps: [{
    instances: "max",  // استخدم كل CPUs
    exec_mode: "cluster"
  }]
}
```

### Nginx Caching:
```nginx
# في /etc/nginx/sites-available/landing-pages
proxy_cache_path /var/cache/nginx levels=1:2 keys_zone=my_cache:10m;

location / {
    proxy_cache my_cache;
    proxy_cache_valid 200 1h;
}
```

---

## ✅ المميزات

مع VPS تحصل على:

- ✅ **صلاحيات كاملة** - تحكم 100%
- ✅ **أداء أفضل** - موارد مخصصة
- ✅ **مرونة عالية** - ثبت أي حاجة
- ✅ **أسهل من cPanel** - بدون قيود
- ✅ **سكريبت تلقائي** - كل حاجة جاهزة
- ✅ **SSL مجاني** - Let's Encrypt
- ✅ **إدارة سهلة** - PM2 + Nginx

---

## 🎁 مكافأة: مراقبة متقدمة

### تثبيت Netdata (مراقبة لايف):
```bash
bash <(curl -Ss https://my-netdata.io/kickstart.sh)

# افتح في المتصفح:
# http://YOUR_VPS_IP:19999
```

---

## 📞 الدعم

**بيانات قاعدة البيانات محفوظة في:**
```
/root/db-credentials.txt
```

**مجلد التطبيق:**
```
/home/appuser/app
```

---

**VPS أسهل وأقوى! 🚀**

لا توجد تعقيدات cPanel، فقط سكريبت واحد وخلاص! 🎉

