#!/bin/bash
# Compress Project for cPanel Upload
# Creates optimized archive ready for deployment

echo "📦 بدء ضغط المشروع للرفع..."
echo ""

# Configuration
PROJECT_NAME="landing-page-builder"
OUTPUT_FILE="${PROJECT_NAME}-$(date +%Y%m%d-%H%M%S).tar.gz"
TEMP_DIR="temp_build"

# Clean previous builds
echo "🧹 تنظيف الملفات المؤقتة..."
rm -rf $TEMP_DIR
rm -f ${PROJECT_NAME}-*.tar.gz

# Create temp directory
mkdir -p $TEMP_DIR

# Copy necessary files
echo "📋 نسخ الملفات الضرورية..."

# Main files
cp package*.json $TEMP_DIR/
cp next.config.ts $TEMP_DIR/
cp tsconfig.json $TEMP_DIR/
cp postcss.config.mjs $TEMP_DIR/
cp ecosystem.config.js $TEMP_DIR/
cp -r prisma $TEMP_DIR/
cp -r src $TEMP_DIR/
cp -r public $TEMP_DIR/

# Documentation
echo "📚 نسخ الوثائق..."
cp README.md $TEMP_DIR/
cp DEPLOYMENT.md $TEMP_DIR/
cp SECURITY.md $TEMP_DIR/
cp QUICK-START.md $TEMP_DIR/
cp env.example.txt $TEMP_DIR/

# Scripts
echo "🛠️  نسخ السكريبتات..."
cp -r scripts $TEMP_DIR/

# Config files
cp .cpanel.yml $TEMP_DIR/ 2>/dev/null || true

# Create .env template
echo "🔧 إنشاء ملف .env template..."
cat > $TEMP_DIR/.env.production << 'EOF'
# قم بتعديل هذه القيم قبل الاستخدام
DATABASE_URL="mysql://username:password@localhost:3306/database_name"
NEXTAUTH_URL="https://yourdomain.com"
NEXTAUTH_SECRET="generate-with-openssl-rand-base64-32"
GOOGLE_CLIENT_ID=""
GOOGLE_CLIENT_SECRET=""
NODE_ENV="production"
PORT=3000
EOF

# Create README for deployment
echo "📄 إنشاء دليل النشر..."
cat > $TEMP_DIR/DEPLOY-INSTRUCTIONS.txt << 'EOF'
=== تعليمات النشر السريعة ===

1. فك الضغط:
   tar -xzf landing-page-builder-*.tar.gz

2. تكوين البيئة:
   cp .env.production .env
   nano .env  # عدّل القيم

3. تثبيت المكتبات:
   npm install --production

4. إعداد قاعدة البيانات:
   npx prisma generate
   npx prisma migrate deploy

5. بدء التطبيق:
   pm2 start ecosystem.config.js

للتفاصيل الكاملة، راجع DEPLOYMENT.md
EOF

# Compress
echo "🗜️  ضغط الملفات..."
tar -czf $OUTPUT_FILE -C $TEMP_DIR .

# Clean up
echo "🧹 تنظيف الملفات المؤقتة..."
rm -rf $TEMP_DIR

# Get file size
SIZE=$(du -h $OUTPUT_FILE | cut -f1)

echo ""
echo "✅ تم ضغط المشروع بنجاح!"
echo "📦 اسم الملف: $OUTPUT_FILE"
echo "📊 الحجم: $SIZE"
echo ""
echo "📤 يمكنك الآن رفع الملف إلى cPanel"
echo ""
echo "الخطوات التالية:"
echo "1. ارفع $OUTPUT_FILE إلى cPanel"
echo "2. فك الضغط في مجلد التطبيق"
echo "3. اتبع التعليمات في DEPLOY-INSTRUCTIONS.txt"
echo ""

