#!/bin/bash
# Production Start Script

echo "🚀 Starting production server..."

# Load environment variables
if [ -f .env ]; then
    export $(cat .env | grep -v '^#' | xargs)
fi

# Run migrations
echo "📊 Running database migrations..."
npx prisma migrate deploy

# Generate Prisma Client
echo "🔧 Generating Prisma Client..."
npx prisma generate

# Start the application
echo "✅ Starting Next.js application..."
NODE_ENV=production npm start

